; Copyright (c) 2005, Stubbe F. Hviid
;   All rights reserved
;+
; NAME:
;   PRO p_write_text_file, file, txt
;
; PURPOSE:
;   Write the content of a text array to a text file
;
; CATEGORY:
;   file io
;
; CALLING SEQUENCE:
;   PRO p_read_text_file, file, txt
;
; INPUTS:
;   file: 	output filename (if not specified then a pickfile dialog will be shown)
;   txt:	strarr with text to be written
;
; OPTIONAL INPUTS:
;   None
;
; KEYWORD PARAMETERS:
;   LABEL					optional string array with PDS label to be attached to the text file at the beginning
;
; RESTRICTIONS:
;   None
;
; EXAMPLE:
;   text = ['Hello', 'World']
;   p_write_text_file. 'c:\temp\test.txt', text
;
; MODIFICATION HISTORY:
;   Written by:  Stubbe F. Hviid  20090508

PRO p_write_text_file, file, txt, LABEL=LABEL

	if n_elements(file) eq 0 then file = dialog_pickfile(FILTER='*.*')

	on_ioerror, ioe

	openw, unit, file, /GET_LUN

	if n_elements(LABEL) ne 0 then begin
		for i=0, n_elements(LABEL)-1 do begin
			printf, unit, LABEL[i]
		endfor
	endif

	if n_elements(txt) ne 0 then begin
		for i=0, n_elements(txt)-1 do begin
			printf, unit, txt[i]
		endfor
	endif

	close, unit
	free_lun, unit

	return

	ioe:
	print, 'IO Error writing to: ' + file
END