PRO p_write_table, file, data, columns, title, format

	if n_elements(format) eq 0 then format = 'F20'

	sd = size(data, /dim)
	nc = n_elements(columns)
	cb = strlen(string(data[0,0], FORMAT='('+format+')'))



	if sd[0] ne nc then begin
		print, 'you must specify the same number of columns titles as there are number of columns
		return
	endif

	fd = p_parse_file_path(file)


	label = ['PDS_VERSION_ID = PDS3', 'RECORD_TYPE      = STREAM']

	label = [label, '^TABLE                 = "' + strupcase(fd.filename) + '"']
	label = [label, 'PRODUCT_CREATION_TIME  = ' + p_timenow()]
	label = [label, 'PRODUCT_ID             = "' + strupcase(fd.name) + '"']
	label = [label, 'DATA_SET_ID            = " "']
	label = [label, 'OBJECT                 = TABLE']
	label = [label, '  NAME                   = "' + title + '"']
	label = [label, '  INTERCHANGE_FORMAT     = ASCII']
	label = [label, '  ROWS                   = ' + strtrim(sd[1], 2)]
	label = [label, '  COLUMNS                = ' + strtrim(sd[0], 2)]
	label = [label, '  ROW_BYTES              = ' + strtrim(sd[0]*cb, 2)]

	for i=0, nc-1 do begin
		label = [label, '  OBJECT                 = COLUMN']
		label = [label, '    NAME                    = ' + columns[i]]
		label = [label, '    DATA_TYPE               = "ASCII_REAL"']
		label = [label, '    START_BYTE              = ' + strtrim(i*cb+1, 2)]
		label = [label, '    BYTES                   = ' + strtrim(cb, 2)]
		label = [label, '    FORMAT                  = "' + format + '"']
		label = [label, '  END_OBJECT             = COLUMN']
	endfor

	label = [label, 'END_OBJECT             = TABLE']
	label = [label, 'END']


	openw, unit, fd.dir + '/' + strupcase(fd.name) + '.LBL', /GET_LUN
	for i=0, n_elements(label)-1 do printf, unit, label[i]
	free_lun, unit

	openw, unit, fd.dir + '/' + strupcase(fd.name) + '.TAB', /GET_LUN
	for i=0, sd[1]-1 do begin
		line = ''
		for j=0, sd[0]-1 do begin
			line = line + string(data[j,i], FORMAT='(' + format + ')')
		endfor
		printf, unit, line
	endfor
	free_lun, unit





END