FUNCTION p_uax2pds, tag

pds_labels = [ $
	'', $                        ;0    H_TYPE              Header type  (D=DISR, I=IMP, O=OSIRIS)
	'', 	$                        ;1    H_DIRECTORY         Directory file last stored in
	'FILE_NAME', $               ;2    H_FILENAME          Filename file was stored as
	'PRODUCT_CREATION_TIME', $   ;3    H_FILETIME          Time file was last written by D_WRITE
	'', $                        ;4    H_LENGTH            Length of header string array
	'', $                        ;5    H_DIMENSION         Number of dimensions in data
	'IMAGE.LINE_SAMPLES', $      ;6    H_XSIZE             Number of columns
	'IMAGE.LINES', $             ;7    H_YSIZE             Number of rows
	'IMAGE.BANDS', $             ;8    H_ZSIZE             Number of images
	'', $                        ;9    H_DATATYPE          Type of data
	'', $                        ;10   H_EXTENSION         Position in header where extension area starts
	'', $                        ;11   H_EXTRA             Position in header where extra area starts
	'', $                        ;12   H_PROCESS           Position in header where processing area starts
	'TARGET_NAME', $             ;13   H_PURPOSE           Purpose of observation
	'MISSION_PHASE_NAME', $      ;14   H_SUBJECT           Subject of observation
	'PRODUCT_CREATION_TIME', $   ;15   H_DATE              Date observation made
	'', $                        ;16   H_ENGINEER          Engineer responsible
	'', $                        ;17   H_SITE              Site of observation
	'DATA_SET_NAME', $           ;18   H_SET_NAME          Text description of data set
	'MISSION_ID', $              ;19   H_PROJECT           Unique ID of image among PDS products
	'IMAGE.DERIVED_MAXIMUM', $   ;20   H_MAXDATA           Max Data Value in Pixel Array
	'', $                        ;21   H_OPTICS_TEMP       EDR OPTICS_TEMPERATURE
	'', $                        ;22
	'SR_TEMPERATURE_STATUS.ROSETTA:CAMERA_T_SENSORHEAD', $    ;23   H_REF_TEMP          CCD electronics reference temperature (MPAE)
	'', $                        ;24   H_DATACMP           Data compressed (long2fix)
	'IMAGE_ID', $                ;25   H_IMAGEID           Image ID
	'', $                        ;26   H_DISKID            disk number
	'', $                        ;27   H_HARDWARE          Hardware Environment
	'', $                        ;28   H_SOURCE            Source of Data Set (Program/System)
	'INSTRUMENT_ID', $           ;29   H_TELESCOPE         Telescope (NAC/WAC)
	'DETECTOR_TYPE', $           ;30   H_DETECTOR          detector type (CCD, IR, PHOTOMETER)
	'DETECTOR_ID', $             ;31   H_SENSOR_ID         sensor id number
	'SR_ACQUIRE_OPTIONS.ROSETTA:AMPLIFIER_ID', $    ;32   H_CHANNEL           ccd output channel (A,B,AB)
	'IMAGE_OBSERVATION_TYPE', $  ;33   H_IMAGTYP           Image type (FULL/FRAME/WIN)
	'SR_ACQUIRE_OPTIONS.ROSETTA:ADC_ID', $          ;34   H_ADCSEL            selected ADC (High/Low/Both/Free)
	'SR_ACQUIRE_OPTIONS.ROSETTA:SHUTTER_PRETRIGGER_DURATION', $ ;35   H_SHPRET            shutter pre trigger time
	'SR_ACQUIRE_OPTIONS.EXPOSURE_DURATION', $       ;36   H_EXPTIME           integration time [sec] for CCD measurement
	'START_TIME', $              ;37   H_IMAGE_TIME        start time of exposure
	'', $                        ;38   H_ABSCAL            absolute calibration factor used
	'', $                        ;39   H_LOCAL_TIME        edr LOCAL_TIME
	'SR_ACQUIRE_OPTIONS.ROSETTA:HARDWARE_BINNING_ID', $ ;40   H_BINNING           binning factor for Image
	'', $                        ;41   H_SHUT1VAL          Shutter blade 1 values as string
	'', $                        ;42   H_SHUT2VAL          Shutter blade 2 values as string
	'', $                        ;43   H_GAIN_AH           gain factor channel A of CCD (MPAE) high
	'', $                        ;44   H_AH_DC_OFFSET      DC offset   channel A of CCD (MPAE) high
	'', $                        ;45   H_GAIN_BH           gain factor channel B of CCD (MPAE) high
	'', $                        ;46   H_BH_DC_OFFSET      DC offset   channel B of CCD (MPAE) high
	'', $                        ;47   H_SHBGAINA          Sensor Head Board Gain Channel A
	'', $                        ;48   H_SHBGAINB          Sensor Head Board Gain Channel B
	'', $                        ;49   H_CCD_SIDE          CCD side exposed for this image
	'IMAGE.FIRST_LINE_SAMPLE', $ ;50   H_COORD_XL          image coordinates (lower x) CCD
	'IMAGE.FIRST_LINE', $        ;51   H_COORD_YL          image coordinates (lower y) CCD
	'', $                        ;52   H_COORD_XU          image coordinates (upper x) CCD
	'', $                        ;53   H_COORD_YU          image coordinates (upper y) CCD
	'SR_MECHANISM_STATUS.FILTER_NUMBER', $           ;54   H_FILTER            filter number in use
	'', $                        ;55   H_GAIN_AL           gain factor channel A of CCD (MPAE) low
	'', $                        ;56   H_AL_DC_OFFSET      DC offset   channel A of CCD (MPAE) low
	'', $                        ;57   H_GAIN_BL           gain factor channel B of CCD (MPAE) low
	'', $                        ;58   H_BL_DC_OFFSET      DC offset   channel B of CCD (MPAE) low
	'', $                        ;59
	'', $                        ;60   H_TIMING_GEN        timing generator code (MPAE)
	'', $                        ;61   H_CAMERA            NAC/WAC BB/EM/FM model
	'', $                        ;62   H_VACUUM            vacuum or not (yes or no)
	'', $                        ;63   H_OPTICS            additional optics on bench (MPAE)
	'', $                        ;64   H_TESTLAMP          external test lamp (MPAE)
	'', $                        ;65   H_SHUT_TIME         opening time of CCD test shutter (MPAE)
	'ROSETTA:GRAYSCALE_TESTMODE_FLAG', $   ;66   H_TESTPATTERN       CRB Test Pattern Y/N
	'ROSETTA:SHUTTER_ERROR_TYPE_ID', $     ;67   H_SHSTAT            Shutter Status (A,B,C,OK)
	'', $                        ;68   H_XB_ORDER          order of channel B data (optical/electrical)
	'', $                        ;69   H_DY_SIZE           ysize of data
	'', $                        ;70   H_PA_DESC           desc if prepixel of chan A in file
	'', $                        ;71   H_PA_XSTART         where prepixel chan A starts in data array
	'', $                        ;72   H_PA_XEND           xend of chan A prepixel in data array
	'', $                        ;73   H_DA_DESC           describ if image data of channel A in file
	'', $                        ;74   H_DA_XSTART         where the image data chan A starts in data array
	'', $                        ;75   H_DA_XEND           where the image data chan A ends in data array
	'', $                        ;76   H_OA_DESC           desc if overclock chan A pixel in data
	'', $                        ;77   H_OA_XSTART         where the overclk chan A data starts in data array
	'', $                        ;78   H_OA_END            where the overclk chan A data ends in data array
	'', $                        ;79   H_PB_DESC           desc if prepixel channel B in file
	'', $                        ;80   H_PB_XSTART         where prepix data chan B starts in array
	'', $                        ;81   H_PB_XEND           where the prepixel chan B end in data array
	'', $                        ;82   H_DB_DESC           desc if image data chan B in file
	'', $                        ;83   H_DB_XSTART         where image data chan B starts in array
	'', $                        ;84   H_DB_XEND           where image data chan B ends in array
	'', $                        ;85   H_OB_DESC           desc if chan B overclk pixels in dataset
	'', $                        ;86   H_OB_XSTART         where overclk data chan B starts in array
	'', $                        ;87   H_OB_XEND           where overclk data chan  B ends in array
	'', $                        ;88   H_DIMG_DESC         desc if double image in data
	'SR_ACQUIRE_OPTIONS.ROSETTA:DITHERING_ENABLED_FLAG', $ ;89   H_DITHER            Decription if Dither ON Y/N
	'', $                        ;90
	'', $                        ;91   H_DY_END            Data Y end if over clk lines
	'', $                        ;92
	'', $                        ;93   H_MISSINGLINES      Number of missing lines in Image
	'', $                        ;94   H_STATUSFLAGS       EGSE tsimg Status
	'', $                        ;95   H_CRBCMDHK          CRB Cmd HK Bytes as string
	'', $                        ;96   H_RAWTSIMG          List of raw EGSE tsimg
	'', $                        ;97
	'', $                        ;98
	'', $                        ;99   H_SHUT_STATUS       Shutter state (open, closed, fail-safe)
	'DETECTOR_TEMPERATURE', $    ;100  H_CCDCOLDT          CCD cold stage thermistor
	'SR_TEMPERATURE_STATUS.ROSETTA:CAMERA_T_SENSORHEAD', $ ;101  H_SHBTEMP           Sensor Head Board temperature
	'SR_TEMPERATURE_STATUS.ROSETTA:CAMERA_T_ADC_1', $          ;102  H_ADCTEMP1          ADC temperature 1
	'SR_TEMPERATURE_STATUS.ROSETTA:CAMERA_T_ADC_2', $          ;103  H_ADCTEMP2          ADC temperature 2
	'SR_TEMPERATURE_STATUS.ROSETTA:CAMERA_T_SHUTTER_MOTOR_1', $;104  H_SHTTEMP1          Shutter Temperature 1
	'SR_TEMPERATURE_STATUS.ROSETTA:CAMERA_T_SHUTTER_MOTOR_2', $;105  H_SHTTEMP2          Shutter temperture 2
	'SR_TEMPERATURE_STATUS.ROSETTA:CAMERA_T_POWER_CONVERTER', $;106  H_CRBPWRT           CRB Power Converter temperature
	'SR_TEMPERATURE_STATUS.ROSETTA:CAMERA_T_DOSIMETER', $      ;107  H_CRBRADT           CRB Radiation Sensor temperature
	'SR_POWER_STATUS.ROSETTA:CAMERA_V_24', $                 ;108  H_V24MON            CRB 24 V Monitor
	'SR_POWER_STATUS.ROSETTA:CAMERA_V_8', $                  ;109  H_V8MON             CRB 8 V Monitor
	'SR_POWER_STATUS.ROSETTA:CAMERA_V_M12', $                ;110  H_VM12MON           CRB -12 V Monitor
	'SR_POWER_STATUS.ROSETTA:CAMERA_V_5_ANALOG', $           ;111  H_V5AMON            CRB 5 V Analog Monitor
	'SR_POWER_STATUS.ROSETTA:CAMERA_V_5_DIGITAL', $          ;112  H_V5DMON            CRB 5 V digital Monitor
	'SR_POWER_STATUS.ROSETTA:CAMERA_V_5', $                  ;113  H_VM5MON            CRB -5 V Monitor
	'SR_POWER_STATUS.ROSETTA:CAMERA_I_24', $                 ;114  H_C24MON            CRB 24 V current
	'SR_POWER_STATUS.ROSETTA:CAMERA_I_8', $                  ;115  H_C8MON             CRB 8 V current
	'SR_POWER_STATUS.ROSETTA:CAMERA_I_M12', $                ;116  H_CM12MON           CRB -12 V current
	'SR_POWER_STATUS.ROSETTA:CAMERA_I_5_ANALOG', $           ;117  H_C5AMON            CRB 5 V analog current
	'SR_POWER_STATUS.ROSETTA:CAMERA_I_5_DIGITAL', $          ;118  H_C5DMON            CRB 5 V digital current
	'SR_POWER_STATUS.ROSETTA:CAMERA_I_5', $                  ;119  H_CM5MON            CRB -5 V current
	'SR_RADIATION_STATUS.ROSETTA:CAMERA_DOSIS', $                                    ;120  H_CRBRADDOS         CRB RAD dosis
	'', $                        ;121
	'', $                        ;122
	'', $                        ;123
	'', $                        ;124
	'SR_MECHANISM_STATUS.ROSETTA:FRONT_DOOR_STATUS_ID', $                        ;125  H_DOORPOS           Door encoder Position
	'', $                        ;126  H_FILTER1POS        Filter Wheel 1 Encoder Position
	'', $                        ;127  H_FILTER2POS        Filter Wheel 2 Encoder Position
	'', $                        ;128  H_FILTER1NUM        Requested Filter Number of 1st Wheel
	'', $                        ;129  H_FILTER2NUM        Requested Filter Number of 2nd Wheel
	'SR_TEMPERATURE_STATUS.ROSETTA:T_NAC_MIRROR_1_AND_3', $ ;130  H_TNACM1M3          Temperature from NAC M1/M3 Thermistor
	'SR_TEMPERATURE_STATUS.ROSETTA:T_NAC_MIRROR_2', $ ;131  H_TNACM2            Temperature from NAC M2 Thermistor
	'SR_TEMPERATURE_STATUS.ROSETTA:T_NAC_PPE_IF_MAIN', $ ;132  H_TPPEM             Temperature from PPE main thermistor
	'SR_TEMPERATURE_STATUS.ROSETTA:T_NAC_PPE_IF_REDUNDANT', $ ;133  H_TPPER             Temperature from PPE red Thermistor
	'SR_TEMPERATURE_STATUS.ROSETTA:T_NAC_DOOR_IF_MAIN', $ ;134  H_TFDMM             Temperature from FDM main thermistor
	'SR_TEMPERATURE_STATUS.ROSETTA:T_NAC_DOOR_IF_REDUNDANT', $ ;135  H_TFDMR             Temperature from FDM red Thermistor
	'', $                        ;136  H_TPPENO            Temperature PPE NonOp Thermistor
	'', $                        ;137  H_TFDMNO            Temperature from FDM Nonop Thermistor
	'', $                        ;138  H_TSCNO             Temperature from SC NonOp Thermistor
	'', $                        ;139  H_TTVTANK           Temperature in TV Tank
	'', $                        ;140  H_PVTANK            Pressure in TV Tank
	'', $                        ;141  H_CALMAIN           Main Calibration Lamp (ON/OFF=1/0)
	'', $                        ;142  H_CALRED            Red Calibration Lamp (ON/OFF=1/0)
	'', $                        ;143  H_TMCBCCD           CCD Temp from MCB
	'', $                        ;144  H_PPROBETV          Probe Pressure in TV Tank
	'SR_TEMPERATURE_STATUS.ROSETTA:T_WAC_STRUCTURE_MAIN_1', $ ;145  H_TWACS1M           WAC Structure Temperature 1 main
	'SR_TEMPERATURE_STATUS.ROSETTA:T_WAC_STRUCTURE_REDUNDANT_1', $ ;146  H_TWACS1R           Wac Structure 1 Temperature red
	'SR_TEMPERATURE_STATUS.ROSETTA:T_WAC_STRUCTURE_MAIN_2', $ ;147  H_TWACS2M           WAC Structure 2 Temperature main
	'SR_TEMPERATURE_STATUS.ROSETTA:T_WAC_STRUCTURE_REDUNDANT_2', $ ;148  H_TWACS2R           WAC Structure 2 Temp red
	'SR_TEMPERATURE_STATUS.ROSETTA:T_WAC3', $ ;149  H_TWAC3             WAC Temperature 3
	'SR_TEMPERATURE_STATUS.ROSETTA:T_WAC4', $ ;150  H_TWAC4             WAC Temperature 4
	'', $                        ;151  H_CAMVREF           Reference Voltage
	'', $                        ;152  H_TWHEEL1MOT        Filterwheel 1 motor Temp
	'', $                        ;153  H_TWHEEL2MOT        Filter wheel Motor 2 Temp
	'', $                        ;154  H_TDOORMOT          Front Door Motor Temperature
	'SR_TEMPERATURE_STATUS.ROSETTA:T_NAC_PPE_IF_MAIN', $ ;155  H_TNACIFPM          NAC IF Plate Temperature main
	'SR_TEMPERATURE_STATUS.ROSETTA:T_NAC_PPE_IF_REDUNDANT', $ ;156  H_TNACIFPR          NAC IF Plate Temperature redundant
	'SR_TEMPERATURE_STATUS.ROSETTA:T_NAC_DOOR_IF_MAIN', $ ;157  H_TNACDIFM          nn
	'SR_TEMPERATURE_STATUS.ROSETTA:T_NAC_DOOR_IF_REDUNDANT', $ ;158  H_TNACDIFR          NAC dd
	'', $                        ;159  H_PHASEFDM          FDM Phase
	'', $                        ;160  H_PHASE1FWM         FWM 1 Phase
	'', $                        ;161  H_PHASE2FWM         FWM2 Phase
	'', $                        ;162  H_PCMSTATUS         PCM status (Bit field)
	'', $                        ;163
	'', $                        ;164
	'', $                        ;165
	'SR_TEMPERATURE_STATUS.ROSETTA:T_BOARD_CONTROLLER', $ ;166  H_TMCBCTRB          MCB Ctrl Board Thermistor
	'SR_TEMPERATURE_STATUS.ROSETTA:T_BOARD_DRIVER', $ ;167  H_TMCBDRVB          MCB Driver Board
	'SR_TEMPERATURE_STATUS.ROSETTA:T_MAIN_PCM', $ ;168  H_TPCMM             PCM MainThermistor
	'SR_TEMPERATURE_STATUS.ROSETTA:T_REDUNDANT_PCM', $ ;169  H_TPCMR             PCM Redundant Thermistor
	'', $                        ;170  H_MCBHK_RAW         MCB HK RAW Values as Comma sep list
	'', $                        ;171  H_PCMHK_RAW         PCM HK RAW Values as Comma sep list
	'', $                        ;172  H_DPUHK_RAW         DPU HK RAW Values as Comma sep list
	'', $                        ;173
	'', $                        ;174
	'', $                        ;175  H_OGSE_RAW          OGSE Parameter list
	'', $                        ;176  H_CAL_IS_LAMPS      Lamp in integration sphere
	'', $                        ;177  H_CAL_IS_LAMP_P     Sphere Lamp Position
	'', $                        ;178  H_CAL_IS_DIODES     Diode readout of Sphere
	'', $                        ;179  H_CAL_TARGET        Experimental Setup
	'', $                        ;180  H_CAL_PHASE         Calibration phase
	'', $                        ;181  H_CAL_CAM_MOUNT     Camera Position
	'', $                        ;182  H_CAL_LIGHTPATH     Description of elements in Light Path
	'', $                        ;183  H_CAL_MOTOR_1       Motor Steps
	'', $                        ;184  H_CAL_MOTOR_2       Motor Steps
	'', $                        ;185  H_CAL_MOTOR_3       Motor Steps
	'', $                        ;186  H_CAL_MC_MOUNT      is the Monochromator mounted ?
	'', $                        ;187  H_CAL_MC_SLIT       Monochromator Slit Width
	'', $                        ;188  H_CAL_MC_WAVEL      Monochromator Wavelength
	'', $                        ;189  H_CAL_CM_POS_X      Collimator X-focus position
	'', $                        ;190  H_CAL_CM_POS_Y      Collimator Y-focus position
	'', $                        ;191  H_CAL_CM_POS_Z      Collimator Z-focus position
	'', $                        ;192  H_CAL_CM_LAMP       Lamp for Collimator
	'', $                        ;193  H_CAL_CM_TARGET     Collimator Target
	'', $                        ;194  H_CAL_CM_FILTER     Collimator Filter
	'', $                        ;195  H_CAL_TEMP          Calibration setup temperatures
	'', $                        ;196  H_CAL_PRESSURE      Calibration pressure
	'', $                        ;197
	'', $                        ;198
	'', $                        ;199
	'', $                        ;200
	'SPACECRAFT_QUATERNION', $   ;201  H_QUATERNION        S/C pointing quaternion
	'MISSION_PHASE_NAME', $      ;202  H_MISSION_PHASE     Rosetta mission phase
	'SC_SUN_POSITION_VECTOR', $  ;203  H_SC_POSITION       x,y,z position of s/c in J2000 Barycentric
	'', $                        ;204  H_SC_VELOCITY       dx,dy,dz of spacecraft velocity in J2000
	'SC_TARGET_POSITION_VECTOR']  ;205  H_COMET_POS         x,y,z position of comet in J2000 barycentric


	t = size(tag, /type)

	if t eq 7 then return, tag

	if t ge 1 AND t lt 4 then begin
		if tag lt n_elements(pds_labels) then return, pds_labels[tag]
	endif
	return, ''

END