; Copyright (c) 2004, Stubbe F. Hviid.  All rights reserved.
;	Unauthorized reproduction prohibited.
;+
; NAME:
;	p_shead
;
; PURPOSE:
;	Display PDS header
;
; CALLING SEQUENCE:
;	p_shead, header
;
; INPUTS:
;	header:	Valid PDS header structure
;		that positional parameters are shown with Initial Caps.
;
; KEYWORD PARAMETERS:
;	NONE
;
; OUTPUTS:
;	NONE
;
; EXAMPLE:
;	p_read, pickfile(), h, d	; read PDS file
;   p_shead, h				    ; show header
;
; MODIFICATION HISTORY:
; 	Written by:	Stubbe F. Hviid, 12/05-2004
;-

PRO p_shead, header
	txt = p_format(header)
	for i=0, n_elements(txt)-1 do print, txt[i]
END