; Copyright (c) 2004, Stubbe F. Hviid.  All rights reserved.
; Unauthorized reproduction prohibited.
;+
; NAME:
;   P_APPROC
; PURPOSE:
;   Append processing history to a header.
; CATEGORY:
;   Database manipulation
; CALLING SEQUENCE:
;   P_APPROC,HEADER_IN,HEADER_OUT,PROCESS,VERS [,STATUS] [,TEXT=TEXT]
; INPUTS:
;   HEADER_IN = input header
;   PROCESS = the process undergone or the text needed for input
;   VERSION = the version number of the process in the form 'V1.0'
;     If straight text is input, this parameter is ignored.
; OPTIONAL INPUT PARAMETERS:
;   ADDITIONAL = additional message text appended to the end of the process history note
; OUTPUTS:
;   HEADER_OUT = the output header with process appended
; OPTIONAL OUTPUT PARAMETERS:
;   STATUS = standard status report
; KEYWORDS:
;   TEXT - if this keyword is set the full text input as PROCESS is placed
;     in the processing history.  Thus instead of entering
;     a process name the image has undergone, you can type in
;     a long comment.
; COMMON BLOCKS:
;   NONE
; RESTRICTIONS:
;   NONE
; PROCEDURE:
;   TRIVIAL
; EXAMPLE:
;   P_APPROC,H,H1,'D_REPAIR','V1.0'  makes a note in header H that D_REPAIR
;     has been used on the corresponding image.
;
;   P_APPROC,H,H1,'I was pissed out of my head when I processed this '+$
;     'image so I bare no responsibility for its contents!',/TEXT
;   The above shows an example of a text comment.  The date is appended
;   to the entry so you can keep a track of the dates when you got
;   pissed!
;
; MODIFICATION HISTORY:
;   25-08-2004 Stubbe F. Hviid


PRO p_approc, header_in, header_out, process, version, additional, TEXT=TEXT

  header_out = header_in

  if keyword_set(TEXT) then begin
    p_append_history, header_out, process, /TEXT
  endif else begin
  	if n_elements(additional) eq 0 then begin
    	p_append_history, header_out, process, version
    endif else begin
    	p_append_history, header_out, process, version, {description: additional}
	endelse
  endelse
END