; Copyright (c) 2004, Stubbe F. Hviid.  All rights reserved.
; Unauthorized reproduction prohibited.
;+
; NAME:
;   PRO p_append_history, header, process, version, parameters
;
; PURPOSE:
;   Append a history node to the header history object of a PDS file
;
; CALLING SEQUENCE:
;   PRO p_append_history, header, process, version, parameters
;
; INPUTS:
;   header:      Valid PDS header structure to be modified
;   process:     Descriptive process description (should be unique for the history)
;                If not then an instance number is appended automatically
;   version:     Version of the processing
;   parameters:  IDL structure with additional parameters to be associated with the node
;
; OUTPUT
;   header:    The modified header is returned in the same var as the input header
;
; RETURNS:
;   Nothing
;
; KEYWORD PARAMETERS:
; PATH_OUT:      : wil return the fully qualified history node path that was actually written
;
; EXAMPLE:
;   p_read, pickfile(), h, d
;   p_append_history, h, 'test process', 'v1.0', {param1: 10, param2: 20}
;
; MODIFICATION HISTORY:
;   Written by: Stubbe F. Hviid, 2009-04-30
;-
PRO p_append_history, header, process, version, parameters, TEXT=TEXT

  p_ensure_history, header

  history = header.history

  if keyword_set(TEXT) then begin
    txt = process
    process = "TEXT"
  endif

  process_in = process;
  next_index = 1
  while p_is_group(history, process) do begin
    process = process_in + ' ' + strtrim(next_index++, 2)
  endwhile

  p_setvalue, history, 'HISTORY.' + process + '.TIME', p_timenow()
  p_setvalue, history, 'HISTORY.' + process + '.USER', strtrim(getenv('USERNAME'), 2)
  if keyword_set(TEXT) then p_setvalue, history, 'HISTORY.' + process + '.TEXT', txt, /AS_STRING
  if n_elements(version) ne 0 then p_setvalue, history, 'HISTORY.' + process + '.VERSION', version, /AS_STRING
  if n_elements(parameters) ne 0 then p_setvalue, history, 'HISTORY.' + process + '.PARAMETERS', parameters

  header = p_set_struct_tag(header, 'history', history)

END