; Copyright (c) 2006, Stubbe F. Hviid.  All rights reserved.
;   Unauthorized reproduction prohibited.
;+
; NAME:
;   FUNCTION p_type_of_string, string_var
;
; PURPOSE:
;   Determine IDL data type of content of string variable
;
; CALLING SEQUENCE:
;   Result = p_type_of_string(string_var)
;
; INPUTS:
;   string_var:		string variable containg value as string
;
; RETURNS:
;   IDL type code (See IDL data type id numbers) of value content of string
;
; EXAMPLE:
;   type = p_type_of_string('Hello World')	; returns 7 (string)
;   type = p_type_of_string('10')	        ; returns 3 (long)
;   type = p_type_of_string('10.5')	        ; returns 5 (double)
;
; MODIFICATION HISTORY:
;   Written by:  Stubbe F. Hviid, 12/05-2004
;-


FUNCTION p_type_of_string, string_var

	tmp = strlowcase(string_var)
	ba = byte(tmp)

	is_num = 0
	is_real = 0
	for i=0, n_elements(ba)-1 do begin


		if ((ba[i] ge byte('0')) AND (ba[i] le byte('9'))) OR (ba[i] eq byte('-')) OR (ba[i] eq byte('+')) then begin
			is_num = 1
		endif else if (ba[i] eq byte('.')) OR (ba[i] eq byte('e')) then begin
			is_real = 1
		endif else begin
			return, 7
		endelse

	endfor

	if is_real eq 1 then return, 5

	return, 3


END