; Copyright (c) 2004, Stubbe F. Hviid.  All rights reserved.
;   Unauthorized reproduction prohibited.
;+
; NAME:
;   PRO p_rhead, file, header, status, OK=OK
;
; PURPOSE:
;   Read a PDS header from a PDS file
;
; CALLING SEQUENCE:
;    p_rhead, file, header, status
;
; INPUTS:
;   file:   The file to read from
;
; OUTPUT:
;   header:   the output PDS header
;   status:  std status block ['S' or 'F' , 'SUCCESS' or 'FAILURE', <procedure>, <error message>]
;
; KEYWORD PARAMETERS:
;   OK          	 will be 1 on success else 0
;   VERBOSE          set to enable all progress print statements (only errors will be shown)
;   HEADER_ONLY:     Oly the PDS label will be read (no expansion of sub object like shutter pulses)
;
; MODIFICATION HISTORY:
;   Written by:  Stubbe F. Hviid, 12/05-2004
;                MK, 31 OCt. 2005, added check for string type of file argument to avoid subtle bug which creates an
;                                  infinite loop if a numerical value is erroneously given as file.
;-

PRO p_rhead, file, header, OK=OK, VERBOSE=VERBOSE, HEADER_ONLY=HEADER_ONLY

	; try to read as PDS3 file
    p_pds_rhead, file, header, OK=OK, VERBOSE=VERBOSE
    if OK then begin
    	header = p_set_struct_tag(header, 'filetype', 'PDS3')
    	header = p_set_struct_tag(header, 'filename', file)
		return
    endif

	; try to read as vicar file
    p_vicar_rhead, file, header, OK=OK, VERBOSE=VERBOSE
    if OK then begin
    	header = p_set_struct_tag(header, 'filetype', 'VICAR')
    	header = p_set_struct_tag(header, 'filename', file)
		return
    endif

	; try to read as FITS file
    p_fits_rhead, file, header, OK=OK, VERBOSE=VERBOSE
    if OK then begin
    	header = p_set_struct_tag(header, 'filetype', 'FITS')
    	header = p_set_struct_tag(header, 'filename', file)
		return
    endif


	; error
	OK = 0
	print, 'ERROR: Cannot read: ' + file


END