; Copyright (c) 2006, Stubbe F. Hviid.  All rights reserved.
;   Unauthorized reproduction prohibited.
;+
; NAME:
;   FUNCTION p_string_encode, string_array
;
; PURPOSE:
;	Pack a string array into a PDS coded multiline string
;   (multiline encoded strings uses the \n code a line separator)
;
; CALLING SEQUENCE:
;    Result = p_string_encode, string_array
;
; INPUTS:
;   string_array:   The string array to be encoded
;
; RETURNS:
;   text string scalar using \n as line separator
;
; KEYWORD PARAMETERS:
;   None
;
; MODIFICATION HISTORY:
;   Written by:  Stubbe F. Hviid, 25/9-2006
;-

FUNCTION p_string_encode, string_array

	out = string_array[0]

	for i=1, n_elements(string_array)-1 do begin
		out = out + '\n' + string_array[i]
	endfor

	return, out
END