; NAME:
;   FUNCTION p_find_embedded_objects, header
;
; PURPOSE:
;   Find embedded objects within the PDS file (IMAGE, TABLE,  ...)
;
; CALLING SEQUENCE:
;   Result = p_find_embedded_objects(header)
;
; INPUTS:
;   header:   Valid PDS header structure
;
; KEYWORD PARAMETERS:
;   NONE
;
; OUTPUTS:
;   unit: Will containg the PDS defined unit of the header item
;
; RETURNS:
;   strings array with the names of the embedded objects
;
; EXAMPLE:
;   p_read, pickfile(), h, d  ; read PDS file
;   print, p_find_embedded_objects(h)
;
; MODIFICATION HISTORY:
;   Written by:  Stubbe F. Hviid, 26/10-2004
;-

FUNCTION p_find_embedded_objects, header

  objs = ['']
  for i=0, n_elements(header.tags)-1 do begin
    if strmid(header.tags[i], 0, 1) eq '^' then begin
      ; its a pointer object
      value = strtrim(header.values[i], 2)
      ; check if the object refers to an embedded object
      fc = strmid(value, 0, 1)
      if fc ne '(' AND fc ne '"' AND fc ne "'" then objs = [objs, strmid(header.tags[i], 1)]
    endif
  endfor

  if n_elements(objs) eq 1 then return, -1

  return, objs[1:*]
END